/*==========================================================================
  TBLIT.C

  Example code to perform a transparent bitblit.

  Copyright (c) 1994-1995 ATI Technologies Inc. All rights reserved
 =========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "..\util\atim64.h"
#include "..\util\sample.h"

#define INSTANCE 0

int main (int argc, char *argv[])
{
    int i;

    // check if Mach64 adapter is installed
    if (detect_mach64 (INSTANCE) != YES_MACH64)
    {
        printf ("mach64 based adapter was not found.\n");
        return (1);
    }

    // fill global query structure by calling Mach 64 ROM
    if (query_hardware () != NO_ERROR)
    {
        printf ("Failed ROM call to query mach64 hardware.\n");
        return (1);
    }

    // Process the command line arguments to override default resolution
    // and color depth settings.
    process_command_line (argc, argv);

    // set an accelerator mode
    if (open_mode (gmode_res, PITCH_XRES, gclr_depth) != NO_ERROR)
    {
        printf ("Error in setting display mode.\n");
        return (1);
    }

    // Check for 24 bpp mode - Compare source is not supported in 24 bpp,
    // it will behave as in 8 bpp modes
    if (modeinfo.bpp == 24)
    {
        // disable accelerator mode and switch back to VGA text mode
        close_mode ();

        printf ("Compare source is not supported in 24 bpp modes.\n");
        return (1);
    }

    // set engine context and clear screen
    init_engine ();
    clear_screen (0, 0, modeinfo.xres, modeinfo.yres);

    // Draw a background with different colored rectangles
    for (i = BLACK; i <= WHITE; i++)
    {
        set_fg_color (get_color_code (i));
        draw_rectangle (i * (modeinfo.xres / 40), i * (modeinfo.yres / 40),
                        modeinfo.xres - (i * 2 * (modeinfo.xres / 40)),
                        modeinfo.yres - (i * 2 * (modeinfo.yres / 40)));
    }


    // Draw the source to be blited
    set_fg_color (get_color_code (WHITE));
    draw_rectangle (0, 0, modeinfo.xres / 8, modeinfo.yres / 6);

    set_fg_color (get_color_code (LIGHTRED));
    draw_rectangle (modeinfo.xres / 64, modeinfo.yres / 48,
                    (modeinfo.xres / 8) - (2 * (modeinfo.xres / 64)),
                    (modeinfo.yres / 6) - (2 * (modeinfo.yres / 48)));

    set_fg_color (get_color_code (LIGHTBLUE));
    draw_rectangle (modeinfo.xres / 32, modeinfo.yres / 24,
                    (modeinfo.xres / 8) - (2 * (modeinfo.xres / 32)),
                    (modeinfo.yres / 6) - (2 * (modeinfo.yres / 24)));

    // wait for a carriage return
    getch ();

    // Set color compare registers to source compare:
    //
    // In this example, the LIGHTBLUE center of the source rectangle
    // is selected as being the source color to ignore when bliting.
    // The resultant blit will contain all the source data except pixels
    // having the same color as the compare color (LIGHTBLUE). Note that
    // the compare source is SOURCE. Also, the compare color and the color
    // pixel being compared are both ANDed with the color compare mask.

    wait_for_fifo (3);
    regw (CLR_CMP_CNTL, COMPARE_SOURCE | COMPARE_EQUAL);
    regw (CLR_CMP_CLR, get_color_code (LIGHTBLUE));
    regw (CLR_CMP_MASK, 0xFFFFFFFF);

    // draw several transparent blits at different locations

    // set src type for blit
    wait_for_fifo (1);
    regw (DP_SRC, FRGD_SRC_BLIT);

    for (i = 0; i < 6; i++)
    {
        blit (0, 0, (modeinfo.xres / 8) + (i * (modeinfo.xres / 8)),
              i * (modeinfo.yres / 6), modeinfo.xres / 8, modeinfo.yres / 6);
    }


    // By changing the compare function from COMPARE_EQUAL to
    // COMPARE_NOT_EQUAL, the resultant blit will contain ONLY the source
    // data having the same color as the compare color (LIGHTBLUE).

    wait_for_fifo (1);
    regw (CLR_CMP_CNTL, COMPARE_SOURCE | COMPARE_NOT_EQUAL);

    // draw several transparent blits at different locations
    for (i = 0; i < 6; i++)
    {
        blit (0, 0, (2 * (modeinfo.xres / 8)) + (i * (modeinfo.xres / 8)),
              i * (modeinfo.yres / 6), modeinfo.xres / 8, modeinfo.yres / 6);
    }

    // wait for a carriage return
    getch ();

    // disable accelerator mode and switch back to VGA text mode
    close_mode ();

    return (0);
}

